#include "GetObjects.js"

function DoChamfer()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	objectpicker.allowFaces();
	objectpicker.allowBReps();
	
	if ( !GetObjects( objectpicker ) )
		return;

	var objects = objectpicker.objects;

	var factory = moi.command.createFactory( 'chamfer' );
	factory.setInput( 0, objects );
	
	if ( !factory.doingEdges && objects.length == 1 && objects.numStandaloneCurves == 1 )
	{
		var numvertices = factory.generateVertices();
		if ( numvertices == 0 )
			return;
	
		moi.ui.beginUIUpdate();
		moi.ui.hideUI( 'SelectPrompt' );
		moi.ui.showUI( 'SelectVerticesPrompt' );
		moi.ui.endUIUpdate();
		
		objectpicker.resetAllow();
		objectpicker.allowPointObjects();
		
		if ( !GetObjects( objectpicker, true ) )
			return;
			
		factory.finishedPickingVertices();
	}
	
	var Use2Distances = false;
	try { Use2Distances = moi.command.getOption( 'ChamferUse2Distances' ); }
	catch(e) {}
	
	
	moi.ui.beginUIUpdate();
	
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.hideUI( 'SelectVerticesPrompt' );	
	moi.ui.showUI( 'DistancePrompt' );
	moi.ui.showUI( 'ChamferOptions' );
	
	if ( factory.doingEdges )
	{
		moi.ui.showUI( 'straightcornerscontainer' );
		moi.ui.bindUIToInput( 'straightcorners', 'value', factory.getInput(1) );
	}
	
	if ( Use2Distances )
	{
		moi.ui.hideUI( 'chamferdistancelabel' );
		moi.ui.showUI( 'chamferdistance1label' );
		moi.ui.showUI( 'dist2tr' );
		
		moi.ui.commandUI.use2distances.value = true;
	}
		
	moi.ui.endUIUpdate();

	var pointpicker = moi.ui.createPointPicker();
	pointpicker.disableSnapToBasePt = true;

	var HaveDistance1 = false;
	var HaveDistance2 = false;
	
	var StartDistance1 = 0.0;
	var StartDistance2 = 0.0;
	
	try
	{
		StartDistance1 = moi.ui.commandUI.distanceinput1.value;
		if ( StartDistance1 != undefined && StartDistance1 > 0.0 )
		{
			HaveDistance1 = true;
			factory.setInput( 3, StartDistance1 );
		}
	}
	catch(e)
	{
	}
	
	try
	{
		StartDistance2 = moi.ui.commandUI.distanceinput2.value;
		if ( StartDistance2 != undefined && StartDistance2 > 0.0 )
		{
			HaveDistance2 = true;
			factory.setInput( 4, StartDistance2 );
		}
	}
	catch(e)
	{
	}
	
	if ( !Use2Distances && HaveDistance1 )
	{
		StartDistance2 = StartDistance1;
		HaveDistance2 = true;
		factory.setInput( 4, StartDistance1 );
	}
	
	if ( HaveDistance1 && HaveDistance2 )
		factory.update();
		
		
	
	var HaveBasePt = false;
	var BasePt = null;
	var OnFirstDistance = true;
	
	while( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'done' )
		{
			break;
		}
		if ( pointpicker.event == 'finished' )
		{
			pointpicker.clearBindings();
		
			if ( !HaveBasePt )
			{
				BasePt = pointpicker.pt;
				HaveBasePt = true;
				
				moi.ui.commandUI.g_BasePt = BasePt;
				pointpicker.bindFunc( moi.ui.commandUI[ (OnFirstDistance || !Use2Distances) ? 'OnPoint1' : 'OnPoint2' ] );
			}
			else
			{
				var OtherPt = pointpicker.pt;
				var dist = moi.vectorMath.distance( BasePt, OtherPt );
				
				if ( dist > 0.0 )
				{
					if ( OnFirstDistance || !Use2Distances )
					{
						moi.ui.commandUI.distanceinput1.value = dist;
						HaveDistance1 = true;
						factory.setInput( 3, dist );
					}
					
					moi.ui.commandUI.distanceinput2.value = dist;
					HaveDistance2 = true;
					factory.setInput( 4, dist );
					
					if ( Use2Distances )
						OnFirstDistance = !OnFirstDistance;
					else
						OnFirstDistance = true;

					factory.update();
				}
				
				HaveBasePt = false;
				moi.ui.clearPickedPoints();
			}
		}
		else if ( pointpicker.event == 'distanceinput1' )
		{
			var dist = moi.ui.commandUI.distanceinput1.value;
			
			if ( dist > 0.0 )
			{
				HaveDistance1 = true;
				factory.setInput( 3, dist );
				
				if ( !Use2Distances )
				{
					HaveDistance2 = true;
					factory.setInput( 4, dist );
				}
				
				factory.update();
			}
		}
		else if ( pointpicker.event == 'distanceinput2' && Use2Distances )
		{
			var dist = moi.ui.commandUI.distanceinput2.value;
			
			if ( dist > 0.0 )
			{
				HaveDistance2 = true;
				factory.setInput( 4, dist );
				factory.update();
			}
		}
		else if ( pointpicker.event == 'use2distances' )
		{
			Use2Distances = moi.ui.commandUI.use2distances.value;
		
			moi.ui.beginUIUpdate();
			
			if ( Use2Distances )
			{
				moi.ui.hideUI( 'chamferdistancelabel' );
				moi.ui.showUI( 'chamferdistance1label' );
				moi.ui.showUI( 'dist2tr' );
			}
			else
			{
				moi.ui.showUI( 'chamferdistancelabel' );
				moi.ui.hideUI( 'chamferdistance1label' );
				moi.ui.hideUI( 'dist2tr' );
			}
			
			moi.ui.endUIUpdate();
			
			try
			{
				var dist1 = moi.ui.commandUI.distanceinput1.value;
				if ( dist1 != undefined && dist1 > 0.0 )
				{
					var dist2 = dist1;
					if ( Use2Distances )
						dist2 = moi.ui.commandUI.distanceinput2.value;
					else
						moi.ui.commandUI.distanceinput2.value = dist1;
					
					if ( dist2 != undefined && dist2 > 0.0 )
					{
						factory.setInput( 3, dist1 );
						factory.setInput( 4, dist2 );
						factory.update();
						HaveDistance1 = true;
						HaveDistance2 = true;
					}
				}
			}
			catch(e)
			{
			}

			moi.command.setOption( 'ChamferUse2Distances', Use2Distances );
		}
	}
	
	if ( !(HaveDistance1 && HaveDistance2) )
		return;
	
	factory.commit();
}

DoChamfer();
